/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.utils.uicontrols.expressionbuilder;

import filenet.vw.toolkit.utils.VWAccessibilityHelper;
import filenet.vw.toolkit.utils.VWPopupMenu;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.event.IVWExpressionToolbarActionListener;
import filenet.vw.toolkit.utils.event.VWExpressionToolbarActionEvent;
import filenet.vw.toolkit.utils.resources.VWResource;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPanel;

public class VWExpressionToolbar
extends JPanel
implements ActionListener {
    public static final int ADMIN = 1;
    public static final int LINKER = 2;
    public static final int FULL = 3;
    public static final int DESIGNER = 4;
    public static final Color BGCOLOR_LTGRAY = new Color(220, 221, 222);
    private static final String[] OPERATORS = new String[]{"+", "-", "*", "/", VWResource.s_isEqualOp, VWResource.s_notEqualOp, VWResource.s_isGreaterThanOp, VWResource.s_isGreaterThanOrEqualOp, VWResource.s_isLessThanOp, VWResource.s_isLessThanOrEqualOp, VWResource.s_notOp};
    private JButton m_operatorsButton = null;
    private VWPopupMenu m_operatorsMenu = null;
    private JButton m_andButton = null;
    private JButton m_orButton = null;
    private JButton m_openParenButton = null;
    private JButton m_closeParenButton = null;
    private JButton m_insertButton = null;
    private JButton m_clearButton = null;
    private JButton m_browseButton = null;
    private GridBagConstraints m_gbCons = null;
    private int m_nMode = 3;
    private Vector m_listeners = null;
    private int m_nType = 1;

    public VWExpressionToolbar(int mode) {
        this.m_nMode = mode;
        this.m_listeners = new Vector();
        this.init(false);
    }

    public VWExpressionToolbar(int mode, int type, boolean bShowParticipants) {
        this.m_nMode = mode;
        this.m_nType = type;
        this.m_listeners = new Vector();
        this.init(bShowParticipants);
    }

    public void setInsertButtonEnable(boolean enable) {
        this.m_insertButton.setEnabled(enable);
    }

    public void setClearButtonEnable(boolean enable) {
        this.m_clearButton.setEnabled(enable);
    }

    public void setEnabled(boolean enable) {
        if (this.m_operatorsButton != null) {
            this.m_operatorsButton.setEnabled(enable);
        }
        if (this.m_andButton != null) {
            this.m_andButton.setEnabled(enable);
        }
        if (this.m_orButton != null) {
            this.m_orButton.setEnabled(enable);
        }
        if (this.m_openParenButton != null) {
            this.m_openParenButton.setEnabled(enable);
        }
        if (this.m_closeParenButton != null) {
            this.m_closeParenButton.setEnabled(enable);
        }
        if (this.m_insertButton != null) {
            this.m_insertButton.setEnabled(enable);
        }
        if (this.m_clearButton != null) {
            this.m_clearButton.setEnabled(enable);
        }
        if (this.m_browseButton != null) {
            this.m_browseButton.setEnabled(enable);
        }
    }

    public void addExpressionToolbarActionListener(IVWExpressionToolbarActionListener l) {
        this.m_listeners.addElement(l);
    }

    public void removeExpressionToolbarActionListener(IVWExpressionToolbarActionListener l) {
        this.m_listeners.removeElement(l);
    }

    public void notifyExpressionToolbarActionListeners(int eventID, Object data) {
        int count;
        if (this.m_listeners != null && (count = this.m_listeners.size()) > 0) {
            VWExpressionToolbarActionEvent event = new VWExpressionToolbarActionEvent(this, eventID, data);
            for (int i = 0; i < count; ++i) {
                IVWExpressionToolbarActionListener l = (IVWExpressionToolbarActionListener)this.m_listeners.elementAt(i);
                l.expressionToolbarActionPerformed(event);
            }
        }
    }

    public void actionPerformed(ActionEvent event) {
        Object src = event.getSource();
        if (src == this.m_operatorsButton) {
            this.performOperatorsButtonAction();
        } else if (src == this.m_andButton) {
            this.performAndButtonAction();
        } else if (src == this.m_orButton) {
            this.performOrButtonAction();
        } else if (src == this.m_openParenButton) {
            this.performOpenParenButtonAction();
        } else if (src == this.m_closeParenButton) {
            this.performCloseParenButtonAction();
        } else if (src == this.m_insertButton) {
            this.performInsertButtonAction();
        } else if (src == this.m_clearButton) {
            this.performClearButtonAction();
        } else if (src == this.m_browseButton) {
            this.performBrowseButtonAction();
        } else if (src instanceof JMenuItem) {
            this.performAddOperatorAction((JMenuItem)src);
        }
    }

    private void init(boolean bShowParticipants) {
        this.setLayout(new GridBagLayout());
        this.setBackground(BGCOLOR_LTGRAY);
        this.m_gbCons = new GridBagConstraints();
        switch (this.m_nMode) {
            case 1: 
            case 2: {
                this.createSimpleControls(false);
                break;
            }
            case 4: {
                this.createSimpleControls(true);
                break;
            }
            default: {
                this.createFullControls(bShowParticipants);
                this.initOperatorsMenu();
            }
        }
    }

    private void createSimpleControls(boolean bAddExtraSpacing) {
        this.m_gbCons.gridx = 0;
        this.m_gbCons.gridy = 0;
        this.m_gbCons.fill = 0;
        this.m_gbCons.weightx = 0.0;
        this.m_gbCons.weighty = 0.0;
        this.m_gbCons.anchor = 21;
        this.m_gbCons.gridheight = 1;
        this.m_gbCons.gridwidth = 1;
        this.m_gbCons.insets = bAddExtraSpacing ? new Insets(0, 0, 0, 4) : new Insets(0, 0, 0, 0);
        this.m_andButton = new JButton(VWResource.s_and);
        VWAccessibilityHelper.setAccessibility(this.m_andButton, this, VWResource.s_and, VWResource.s_and);
        this.m_andButton.addActionListener(this);
        this.add((Component)this.m_andButton, this.m_gbCons);
        ++this.m_gbCons.gridx;
        this.m_orButton = new JButton(VWResource.s_or);
        VWAccessibilityHelper.setAccessibility(this.m_orButton, this, VWResource.s_or, VWResource.s_or);
        this.m_orButton.addActionListener(this);
        this.add((Component)this.m_orButton, this.m_gbCons);
        ++this.m_gbCons.gridx;
        this.m_openParenButton = new JButton("(");
        VWAccessibilityHelper.setAccessibility(this.m_openParenButton, this, "(", "(");
        this.m_openParenButton.addActionListener(this);
        this.add((Component)this.m_openParenButton, this.m_gbCons);
        ++this.m_gbCons.gridx;
        this.m_gbCons.weightx = 1.0;
        this.m_closeParenButton = new JButton(")");
        VWAccessibilityHelper.setAccessibility(this.m_closeParenButton, this, ")", ")");
        this.m_closeParenButton.addActionListener(this);
        this.add((Component)this.m_closeParenButton, this.m_gbCons);
        ++this.m_gbCons.gridx;
        this.m_gbCons.weightx = 0.0;
        this.m_gbCons.anchor = 22;
        if (this.m_nMode == 2) {
            this.m_insertButton = new JButton(VWResource.s_insert);
            VWAccessibilityHelper.setAccessibility(this.m_insertButton, this, VWResource.s_insert, VWResource.s_insert);
            this.m_insertButton.addActionListener(this);
            this.add((Component)this.m_insertButton, this.m_gbCons);
        }
        ++this.m_gbCons.gridx;
        this.m_gbCons.insets = new Insets(0, 0, 0, 0);
        this.m_clearButton = new JButton(VWResource.s_clear);
        VWAccessibilityHelper.setAccessibility(this.m_clearButton, this, VWResource.s_clear, VWResource.s_clear);
        this.m_clearButton.addActionListener(this);
        this.add((Component)this.m_clearButton, this.m_gbCons);
    }

    private void createFullControls(boolean bShowParticipants) {
        this.m_gbCons.anchor = 21;
        this.m_gbCons.fill = 0;
        this.m_gbCons.gridx = 0;
        this.m_gbCons.gridy = 0;
        this.m_gbCons.weightx = 0.0;
        this.m_gbCons.weighty = 0.0;
        this.m_gbCons.gridheight = 1;
        this.m_gbCons.gridwidth = 1;
        this.m_gbCons.insets = new Insets(0, 0, 0, 0);
        this.m_operatorsButton = new JButton(VWResource.s_operators);
        VWAccessibilityHelper.setAccessibility(this.m_operatorsButton, this, VWResource.s_operators, VWResource.s_operators);
        this.m_operatorsButton.addActionListener(this);
        this.add((Component)this.m_operatorsButton, this.m_gbCons);
        ++this.m_gbCons.gridx;
        this.m_gbCons.insets = new Insets(0, 0, 0, 0);
        this.m_andButton = new JButton(VWResource.s_and);
        VWAccessibilityHelper.setAccessibility(this.m_andButton, this, VWResource.s_and, VWResource.s_and);
        this.m_andButton.addActionListener(this);
        this.add((Component)this.m_andButton, this.m_gbCons);
        ++this.m_gbCons.gridx;
        this.m_orButton = new JButton(VWResource.s_or);
        VWAccessibilityHelper.setAccessibility(this.m_orButton, this, VWResource.s_or, VWResource.s_or);
        this.m_orButton.addActionListener(this);
        this.add((Component)this.m_orButton, this.m_gbCons);
        ++this.m_gbCons.gridx;
        this.m_openParenButton = new JButton("(");
        VWAccessibilityHelper.setAccessibility(this.m_openParenButton, this, "(", "(");
        this.m_openParenButton.addActionListener(this);
        this.add((Component)this.m_openParenButton, this.m_gbCons);
        ++this.m_gbCons.gridx;
        this.m_gbCons.weightx = 1.0;
        this.m_closeParenButton = new JButton(")");
        VWAccessibilityHelper.setAccessibility(this.m_closeParenButton, this, ")", ")");
        this.m_closeParenButton.addActionListener(this);
        this.add((Component)this.m_closeParenButton, this.m_gbCons);
        this.m_gbCons.anchor = 22;
        ++this.m_gbCons.gridx;
        this.m_gbCons.weightx = 0.0;
        this.m_insertButton = new JButton(VWResource.s_insert);
        VWAccessibilityHelper.setAccessibility(this.m_insertButton, this, VWResource.s_insert, VWResource.s_insert);
        this.m_insertButton.addActionListener(this);
        this.add((Component)this.m_insertButton, this.m_gbCons);
        if (this.m_nType == 32 || this.m_nType == 64 && bShowParticipants) {
            ++this.m_gbCons.gridx;
            this.m_gbCons.weightx = 0.0;
            this.m_browseButton = new JButton(VWResource.s_browse);
            VWAccessibilityHelper.setAccessibility(this.m_browseButton, this, VWResource.s_browse, VWResource.s_browse);
            this.m_browseButton.addActionListener(this);
            this.add((Component)this.m_browseButton, this.m_gbCons);
        }
        ++this.m_gbCons.gridx;
        this.m_gbCons.insets = new Insets(0, 0, 0, 0);
        this.m_clearButton = new JButton(VWResource.s_clear);
        VWAccessibilityHelper.setAccessibility(this.m_clearButton, this, VWResource.s_clear, VWResource.s_clear);
        this.m_clearButton.addActionListener(this);
        this.add((Component)this.m_clearButton, this.m_gbCons);
    }

    private void initOperatorsMenu() {
        this.m_operatorsMenu = new VWPopupMenu();
        if (OPERATORS != null) {
            for (int i = 0; i < OPERATORS.length; ++i) {
                JMenuItem menuItem = new JMenuItem(OPERATORS[i]);
                menuItem.addActionListener(this);
                this.m_operatorsMenu.add(menuItem);
            }
        }
    }

    private void performAddOperatorAction(JMenuItem menuItem) {
        String operatorString = menuItem.getText();
        if (VWStringUtils.compare(operatorString, VWResource.s_notOp) == 0) {
            operatorString = " not ";
        } else if (VWStringUtils.compare(operatorString, VWResource.s_isEqualOp) == 0) {
            operatorString = "=";
        } else if (VWStringUtils.compare(operatorString, VWResource.s_notEqualOp) == 0) {
            operatorString = "<>";
        } else if (VWStringUtils.compare(operatorString, VWResource.s_isGreaterThanOp) == 0) {
            operatorString = ">";
        } else if (VWStringUtils.compare(operatorString, VWResource.s_isGreaterThanOrEqualOp) == 0) {
            operatorString = ">=";
        } else if (VWStringUtils.compare(operatorString, VWResource.s_isLessThanOp) == 0) {
            operatorString = "<";
        } else if (VWStringUtils.compare(operatorString, VWResource.s_isLessThanOrEqualOp) == 0) {
            operatorString = "<=";
        }
        this.notifyExpressionToolbarActionListeners(4, operatorString);
    }

    private void performOperatorsButtonAction() {
        this.m_operatorsMenu.show(this.m_operatorsButton, 0, this.m_operatorsButton.getHeight());
    }

    private void performAndButtonAction() {
        this.notifyExpressionToolbarActionListeners(4, " and ");
    }

    private void performOrButtonAction() {
        this.notifyExpressionToolbarActionListeners(4, " or ");
    }

    private void performOpenParenButtonAction() {
        this.notifyExpressionToolbarActionListeners(4, "(");
    }

    private void performCloseParenButtonAction() {
        this.notifyExpressionToolbarActionListeners(4, ")");
    }

    private void performInsertButtonAction() {
        this.notifyExpressionToolbarActionListeners(1, null);
    }

    private void performClearButtonAction() {
        this.notifyExpressionToolbarActionListeners(3, null);
    }

    private void performBrowseButtonAction() {
        this.notifyExpressionToolbarActionListeners(5, null);
    }
}

